// Jmeno:    Marek Bober
//
// Projekt:  Graficke zobrazeni algoritmu trideni
//
// Soubory:  egavga.bgi, trideni.cpp, mys.h, data.txt
// Ovladani: Pomoci mysi+klavesa ENTER
// Pozn. 1:  Program si behem spusteni vytvori soubor data.$$$,
//           ktery pak pri ukonceni smaze.

// definovani knihoven
#include <graphics.h>                           //grafika
#include <stdlib.h>                             //standard
#include <string.h>                             //retezce
#include <stdio.h>                              //vystup
#include <conio.h>                              //podpora
#include <dos.h>                                //system
#include "myska.h"                              //mys

void trid();     				// setrideni poli
void plocha();     				// vykresleni plochy
void nacteni_dat();         			// nacteni entit
void init_grafiky();				// inicializace grafiky

typedef struct               			// defince struktury
 {                                              //            obdelniku
  int x1,y1,x2,y2;                              // souradnice
 } OBDEL;

int   maxx=0;					// maximalni x rozmer
int   maxy=0;                                   // maximalni y rozmer
int   sx,sy;                                    // umisteni pocatku

char  tl1[10],tl2[10],na1[20],                  // definice textovych
      na2[20],na3[30],st[20];                   //     promenych
const int vel=4;                                // pocet obdelniku
OBDEL obd[vel];                                 // definice obdelniku

// Zacatek hlavniho programu
int main(void)
{
 int kon=0;                                     // ukoncovaci promena
 int a=vel-1;         			        // cislo obdelniku
 int c=10;                                      // pomocna promena
 int x=0;                                       // x souradnice mysi
 int y=0;                                       // y souradnice mysi

 nacteni_dat();                                 // nacteni dat
 init_grafiky();                                // inicializace grafiky
 plocha();                                      // vykresleni plochy
 mouse_x_range(obd[a].x1-c,obd[a+1].x2+c);      // min a max x pohyb mysi
 mouse_y_range(obd[a].y1-c,obd[a+1].y2+c);      // min a max y pohyb mysi
 set_mouse((obd[a].x2-obd[a].x1)/2+obd[a].x1,   // nastaveni mysi
	   (obd[a].y2-obd[a].y1)/2+obd[a].y1);
 show_mouse();                                  // ukazani mysi
 c=0;
 do
  {
   c=status(3,&x,&y);                           // sledovani stavu mysi
   if ((c==1) && (x>obd[a+1].x1) && (x<obd[a+1].x2)
	      && (y>obd[a+1].y1) && (y<obd[a+1].y2)) kon=1;// volani konce
   if ((c==1) && (x>obd[a].x1) && (x<obd[a].x2)
	      && (y>obd[a].y1) && (y<obd[a].y2)) trid();   // volani trid
  }
 while (!kon);                                  // potvrzeni podminky
 closegraph();                                  // uzavreni grafiky
 remove("data.$$$");                            // smazani pomoc. soub
 return 0;                                      // navratova hodnota
}
// Konec hlavniho programu

// Definovani funkci
void cisti()                                    // vycisti obdelniky
{
 int i=0;                                       // pomocna promenna
 setfillstyle(0,0);                             // nastaveni vyplne
 for (i=1;i<vel-1;i++) bar(obd[i].x1+1,obd[i].y1+1,obd[i].x2-1,obd[i].y2-1);
}                                               // vyplneni obdelniku

void trid()     				// setrideni poli
{
 int i,j,a,c;                                   // pomocne promenne
 const int b=300;                               // pocet primek
 int p[b][vel-1];                               // pole primek

 hide_mouse();                                  // schovej mysku
 cisti();                                       // vycist obdelniky
 setcolor(1);                                   // nastav barvu na modrou
 randomize();                                   // nahodne velikosti primek
 for (j=1;j<vel-1;j++)                          // cyklus generovani
  {                                             //   nahodnych delek primek
   for (i=0;i<300;i++)
    {
     p[i][j]=random(299)+1;
     line(obd[j].x1+1,obd[j].y1+i+1,obd[j].x1+p[i][j],obd[j].y1+i+1);
						// vykresleni primek
    }
  }
 setcolor(4);                                   // nastav barvu na zelenou
 settextstyle(0,0,1);                           // typ pisma
 settextjustify(1,1);                           // zarovnani pisma
 outtextxy(maxx/2,380,st);		   	// zobrazeni textu
 getch();                                       // cekej na stisk klavesy
 setcolor(0);                                   // nastav barvu na cernou
 settextstyle(0,0,1);                           // typ pisma
 settextjustify(1,1);                           // zarovnani pisma
 outtextxy(maxx/2,380,st);		   	// zobrazeni textu
 // typ trideni: buble sort
 for (i=b;i>0;i--)
  for (j=1;j<b;j++)
   {
    if (p[j][vel-3]>p[j+1][vel-3])
     {
      // vymazani starych primek
      setcolor(0);
      line(obd[vel-3].x1+1,obd[vel-3].y1+j,obd[vel-3].x2-1,obd[vel-3].y1+j);
      line(obd[vel-3].x1+1,obd[vel-3].y1+j+1,
	   obd[vel-3].x2-1,obd[vel-3].y1+j+1);
      c=p[j][vel-3];
      p[j][vel-3]=p[j+1][vel-3];
      p[j+1][vel-3]=c;
      // vykresleni novych primek
      setcolor(1);
      line(obd[vel-3].x1+1,obd[vel-3].y1+j,
	   obd[vel-3].x1+p[j][vel-3],obd[vel-3].y1+j);
      line(obd[vel-3].x1+1,obd[vel-3].y1+j+1,
	   obd[vel-3].x1+p[j+1][vel-3],obd[vel-3].y1+j+1);
     }
   }
 setcolor(4);                                   // nastav barvu na zelenou
 settextstyle(0,0,1);                           // typ pisma
 settextjustify(1,1);                           // zarovnani pisma
 outtextxy(maxx/2,380,st);		   	// zobrazeni textu
 getch();                                       // cekej na stisk klavesy
 setcolor(0);                                   // nastav barvu na cernou
 settextstyle(0,0,1);                           // typ pisma
 settextjustify(1,1);                           // zarovnani pisma
 outtextxy(maxx/2,380,st);	  	 	// zobrazeni textu
 // typ trideni: selection sort
 for (i=1;i<b+1;i++)
  {
   c=i;
   a=p[i][vel-2];
   for (j=i+1;j<(b+1);j++)
   {
    if (p[j][vel-2]<a)
     {
      c=j;
      a=p[j][vel-2];
     }
   }
   // vymazani starych primek
   setcolor(0);
   line(obd[vel-2].x1+1,obd[vel-2].y1+i,obd[vel-2].x2-1,obd[vel-2].y1+i);
   line(obd[vel-2].x1+1,obd[vel-2].y1+c,obd[vel-2].x2-1,obd[vel-2].y1+c);
   p[c][vel-2]=p[i][vel-2];
   p[i][vel-2]=a;
   // vykresleni novych primek
   setcolor(1);
   line(obd[vel-2].x1+1,obd[vel-2].y1+i,
	obd[vel-2].x1+p[i][vel-2],obd[vel-2].y1+i);
   line(obd[vel-2].x1+1,obd[vel-2].y1+c,
	obd[vel-2].x1+p[c][vel-2],obd[vel-2].y1+c);
  }
 show_mouse();                                  // ukaz mysku
}

void obdelnik(int c)                            // vykresleni obdelniku
{
 setcolor(15);                                  // nastav barvu na bilou
 rectangle(obd[c].x1,obd[c].y1,obd[c].x2,obd[c].y2);// kresli obdelnik
 setcolor(7);                                   // nastav barvu na sv sedou
 rectangle(obd[c].x1-1,obd[c].y1-1,obd[c].x2+1,obd[c].y2+1);
 setcolor(8);                                   // nastav barvu na tm sedou
 rectangle(obd[c].x1-2,obd[c].y1-2,obd[c].x2+2,obd[c].y2+2);
}

void plocha()    				// vykresleni plochy
{
 int x=0;                                       // pomocna promenna
 int y=0;                                       // pomocna promenna
 int a=3;                                       // pomocna promenna

 x=(obd[a].x2-obd[a].x1)/2+obd[a].x1;           // x centrovani textu
 y=(obd[a].y2-obd[a].y1)/2+obd[a].y1;           // y centrovani textu
 settextstyle(0,0,1);                           // typ pisma
 settextjustify(1,1);                           // zarovnani pisma
 outtextxy(maxx/2,sy+20,na3);    		// zobrazeni textu
 setcolor(2);
 settextjustify(0,1);
 outtextxy(obd[1].x1,40,na1);
 outtextxy(obd[2].x1,40,na2);
 settextjustify(1,1);
 outtextxy(x,y,tl1);
 a=4;
 x=(obd[a].x2-obd[a].x1)/2+obd[a].x1;
 y=(obd[a].y2-obd[a].y1)/2+obd[a].y1;
 outtextxy(x,y,tl2);
 obdelnik(1);obdelnik(2);obdelnik(3);obdelnik(4);
 settextjustify(0,1);
 setcolor(15);
 outtextxy(0,maxy-10,"(c) 2000");
 settextjustify(1,1);
 outtextxy(maxx/2,maxy-10,"Vytvoril: Marek Bober");
 settextjustify(2,1);
 outtextxy(maxx,maxy-10,"Skupina: DL98577");
}


void nacteni_dat()                              // nacteni dat ze souboru
{
 FILE *f;	                                // soubor pro cteni
 char t[80];
 int  j;

 if ((f=fopen("data.txt","r")) == NULL )        // test otevreni souboru
  {
   printf("Soubor DATA.TXT se nepodarilo otevrit\n");
   return;
  }
 fgets(t,10,f);j=0;j=strlen(t)-1;strncpy(tl1,t,j);// nacteni dat
 fgets(t,10,f);j=0;j=strlen(t)-1;strncpy(tl2,t,j);// nacteni dat
 fgets(t,20,f);j=0;j=strlen(t)-1;strncpy(na1,t,j);// nacteni dat
 fgets(t,20,f);j=0;j=strlen(t)-1;strncpy(na2,t,j);// nacteni dat
 fgets(t,30,f);j=0;j=strlen(t)-1;strncpy(na3,t,j);// nacteni dat
 fgets(t,20,f);j=0;j=strlen(t)-1;strncpy(st,t,j); // nacteni dat
 fclose(f);                                       // zavreni souboru
 obd[1].x1=sx+2;  obd[1].y1=sy+50;obd[1].x2=sx+302;obd[1].y2=sy+352;
 obd[2].x1=sx+338;obd[2].y1=sy+50;obd[2].x2=sx+638;obd[2].y2=sy+352;
 obd[3].x1=sx+222;obd[3].y1=sy+420;obd[3].x2=sx+302;obd[3].y2=sy+450;
 obd[4].x1=sx+331;obd[4].y1=sy+420;obd[4].x2=sx+411;obd[4].y2=sy+450;
}                                                 // definice obdelniku

void init_grafiky()				// inicializace grafiky
{
 int gdriver=DETECT;                            // inicializace driveru
 int gmode;                                     // inicializace modu
 int errorcode;

 clrscr();                                      // vymaz obrazovky
 initgraph(&gdriver, &gmode, "");		// incializace grafiky
 errorcode = graphresult();
 if (errorcode != grOk)                         // zjisteni chyb grafiky
  {
   printf("Chyba grafiky: %s\n", grapherrormsg(errorcode));
   exit(1);
  }
 maxx=getmaxx();                                // max x souradnice
 maxy=getmaxy();                      		// max y souradnice
 sx=0;                                          // nastaveni x pocatku
 sy=maxy-maxy;                                  // nastaveni y pocatku
}
