/* hlavickovy soubor mysky */

#ifndef __myska_h__
#define __myska_h__

#include<dos.h>

#define	AX r.x.ax
#define BX r.x.bx
#define CX r.x.cx
#define DX r.x.dx
#define ES s.es
#define INT int86(0x33, &r, &r)

void show_mouse(void) 				/* ukaz mysku 		*/
{
 union REGS r;
 AX=0x0001;
 int86(0x33,&r,&r);
}

void hide_mouse(void) 				/* schovej mysku 	*/
{
 union REGS r;
 AX=0x0002;
 int86(0x33,&r,&r);
}

void set_mouse(int x,int y) 			/* nastav mysku 	*/
{
 union REGS r;
 AX=0x0004;
 CX=x;
 DX=y;
 int86(0x33,&r,&r);
}

int  state_mouse(int *x,int *y)  		/* sleduj mysku 	*/
{
 union REGS r;
 AX=0x0003;
 int86(0x33,&r,&r);
 *x=CX;
 *y=DX;
 return(BX);
}

void mouse_x_range(int xmin, int xmax) 		/* x-ova mez min a max	*/
{
 union REGS r;
 AX =0x0007;
 CX = xmin;
 DX = xmax;
 int86(0x33,&r,&r);
}

void mouse_y_range(int ymin, int ymax)  	/* y-ova mez min a max	*/
{
 union REGS r;
 AX = 0x0008;
 CX = ymin;
 DX = ymax;
 int86(0x33,&r,&r);
}

int status(int button_mask, int *x, int *y) 	/* stav mysky 		*/
{
 union REGS r;
 AX = 3;
 BX = button_mask;
 INT;
 *x = CX;
 *y = DX;
 return BX;
}

#endif