/* Program: Vyhledavani v textu pomoci algoritmu Knuth-Morris-Pratt

   Vypracoval: Marek Bober
   Datum:      29.11.2001
*/
#include <stdio.h>
#include <dos.h>
#include <math.h>
#include <stdlib.h>
#include <string.h>

int main(int argc, char **argv)
{
 if (argc<3)
  {
   printf("\n Pouziti:\n");
   printf("           kmpalg [-v] VZOR ZDROJ\n");
   printf("\n -v ... vyhleda vsechny vyskyty\n\n");
   printf("Priklad:\n");
   printf("        kmpalg are mystery.poe\n");
   return 1;
  }

 char vzor[80], text[80], soubor[9];
 int DV, DT;
 int i, vsechno, nalezeno, *citac, posun;
 struct time t1, t2;
 FILE *f;

 citac=(int *)malloc(sizeof(int));

 if (strcmp("-v",argv[1])==0)
  {
   vsechno=1;
   strcpy(vzor,argv[2]);
   strcpy(soubor,argv[3]);
  }
 else
  {
   vsechno=0;
   strcpy(vzor,argv[1]);
   strcpy(soubor,argv[2]);
  }

 if ((f=fopen(soubor,"rt")) == NULL)
  {
   fprintf(stderr, "Nemohu otevrit soubor.\n");
   return 1;
  }

 gettime(&t1);
 printf("\nVYHLEDAVAM\n\n");
 printf("Nalezeny [radek,sloupec]:\n\n");
 (*citac)=1;
 nalezeno=0;
 while (fgets(text,80,f)!=NULL)
  {
   DV=strlen(vzor);
   DT=strlen(text);
   posun=0;
   do
    {
     i=0;
     while ((i<DV) && (vzor[i]==text[posun+i])) i++;
     if (i==DV)
      {
       printf("[%5d,%2d]",*citac,posun+1);
       if (vsechno==0) return 0;
       nalezeno++;
       i=1;
      }
     if (i==0) i=1;
     posun=posun+i;
    }
   while (posun<DT);
   (*citac)++;
  }
 gettime(&t2);
 printf("\n\nPocet nalezenych vyskytu slova [%s] je: %d\n",vzor,nalezeno);
 printf("Cas cyhledani: %2d:%02d:%02d.%02d\n",
       abs(t2.ti_hour-t1.ti_hour),abs(t2.ti_min-t1.ti_min),
       abs(t2.ti_sec-t1.ti_sec)  ,abs(t2.ti_hund-t1.ti_hund));
 printf("\nKONEC\n");
 fclose(f);

 return 0;
}
