import javax.swing.*;
import javax.swing.border.*;
import java.awt.*;
import java.awt.event.*;

public class Gui extends JFrame {
	//komponenty
	JTextField valueText;
	JPanel panelMain;
	JRadioButton normalButton, bigButton;
	ButtonGroup allButton;
	JButton Button1,Button2,Button3,Button4,Button5,Button6,Button7,Button8,Button9,Button0;
	JButton plusButton,minusButton,multiButton,divButton,decButton,equalsButton,clearButton;
	JLabel title;
	//layout managery
	GridBagLayout gbLayout;
	GridBagConstraints gbConst;
	//cislo
	Double num1,num2;
	String operator;

	Gui() {
		super.setTitle("Cviceni 5 - Kalkulacka");
		//vytvoreni layout manageru s podminkami
		gbLayout = new GridBagLayout();
		gbConst = new GridBagConstraints();

		this.setLayout(gbLayout);
		this.setResizable(false);
		this.setSize(230,300);
		//vlozi komponenty
		addComponent();
		//umozni zavrit okno
		addWindowListener(new WindowAdapter() {
			public void windowClosing(WindowEvent e) {
				System.exit(1);
			}
		});
	}
	
	private void addComponent() {
		//display
		valueText = new JTextField("0");
		valueText.setHorizontalAlignment(JTextField.RIGHT);
		valueText.setEditable(false);
		//urceni umisteni pomoci parametru omezeni
		gbConst.gridx = 0;
		gbConst.gridy = 0;
		gbConst.gridwidth = 4;
		gbConst.gridheight = 1;
		gbConst.weightx = 0;
		gbConst.weighty = 0;
		gbConst.insets.top = 5;
		gbConst.insets.left = 5;
		gbConst.fill = GridBagConstraints.BOTH;	
		gbConst.anchor = GridBagConstraints.CENTER;
		gbLayout.setConstraints(valueText,gbConst);
		this.add(valueText);
	
		//panel s prepinaci
		panelMain = new JPanel();
		panelMain.setBorder(new EtchedBorder(EtchedBorder.LOWERED));
		gbConst.gridx = 0;
		gbConst.gridy = 1;
		gbConst.gridwidth = 4;
		gbConst.gridheight = 1;
		gbLayout.setConstraints(panelMain,gbConst);	
		this.add(panelMain);

		//definovani skupiny prepinacu		
		allButton = new ButtonGroup();
		//prepinac normal		
		normalButton = new JRadioButton("Normal",true);
		normalButton.addActionListener(new ChangeFont());
		allButton.add(normalButton);
		//prepinac big
		bigButton = new JRadioButton("Big");
		bigButton.addActionListener(new ChangeFont());
		allButton.add(bigButton);
		//umisteni na panel		
		panelMain.add(normalButton);
		panelMain.add(bigButton);
		
		//tlacitka s cislicemi
		Button7 = new JButton("7");
		Button7.addActionListener(new ClickNumber());
		gbConst.gridx = 0;
		gbConst.gridy = 2;
		gbConst.gridwidth = 1;
		gbConst.gridheight = 1;
		gbLayout.setConstraints(Button7,gbConst);	
		this.add(Button7);
		Button8 = new JButton("8");
		Button8.addActionListener(new ClickNumber());
		gbConst.gridx = 1;
		gbConst.gridy = 2;
		gbLayout.setConstraints(Button8,gbConst);	
		this.add(Button8);
		Button9 = new JButton("9");
		Button9.addActionListener(new ClickNumber());
		gbConst.gridx = 2;
		gbConst.gridy = 2;
		gbLayout.setConstraints(Button9,gbConst);	
		this.add(Button9);
		plusButton = new JButton("+");
		plusButton.addActionListener(new ClickOper());
		gbConst.gridx = 3;
		gbConst.gridy = 2;
		gbLayout.setConstraints(plusButton,gbConst);	
		this.add(plusButton);	
		Button4 = new JButton("4");
		Button4.addActionListener(new ClickNumber());
		gbConst.gridx = 0;
		gbConst.gridy = 3;
		gbLayout.setConstraints(Button4,gbConst);	
		this.add(Button4);
		Button5 = new JButton("5");
		Button5.addActionListener(new ClickNumber());
		gbConst.gridx = 1;
		gbConst.gridy = 3;
		gbLayout.setConstraints(Button5,gbConst);	
		this.add(Button5);
		Button6 = new JButton("6");
		Button6.addActionListener(new ClickNumber());
		gbConst.gridx = 2;
		gbConst.gridy = 3;
		gbLayout.setConstraints(Button6,gbConst);	
		this.add(Button6);
		minusButton = new JButton("-");
		minusButton.addActionListener(new ClickOper());
		gbConst.gridx = 3;
		gbConst.gridy = 3;
		gbLayout.setConstraints(minusButton,gbConst);	
		this.add(minusButton);
		Button1 = new JButton("1");
		Button1.addActionListener(new ClickNumber());
		gbConst.gridx = 0;
		gbConst.gridy = 4;
		gbLayout.setConstraints(Button1,gbConst);	
		this.add(Button1);
		Button2 = new JButton("2");
		Button2.addActionListener(new ClickNumber());
		gbConst.gridx = 1;
		gbConst.gridy = 4;
		gbLayout.setConstraints(Button2,gbConst);	
		this.add(Button2);
		Button3 = new JButton("3");
		Button3.addActionListener(new ClickNumber());
		gbConst.gridx = 2;
		gbConst.gridy = 4;
		gbLayout.setConstraints(Button3,gbConst);	
		this.add(Button3);
		multiButton = new JButton("*");
		multiButton.addActionListener(new ClickOper());
		gbConst.gridx = 3;
		gbConst.gridy = 4;
		gbLayout.setConstraints(multiButton,gbConst);	
		this.add(multiButton);
		Button0 = new JButton("0");
		Button0.addActionListener(new ClickNumber());
		gbConst.gridx = 0;
		gbConst.gridy = 5;
		gbLayout.setConstraints(Button0,gbConst);	
		this.add(Button0);
		decButton = new JButton(",");
		decButton.addActionListener(new ClickDec());
		gbConst.gridx = 1;
		gbConst.gridy = 5;
		gbLayout.setConstraints(decButton,gbConst);	
		this.add(decButton);
		clearButton = new JButton("Clr");
		clearButton.addActionListener(new ClickClear());
		gbConst.gridx = 2;
		gbConst.gridy = 5;
		gbLayout.setConstraints(clearButton,gbConst);	
		this.add(clearButton);
		divButton = new JButton("/");
		divButton.addActionListener(new ClickOper());
		gbConst.gridx = 3;
		gbConst.gridy = 5;
		gbLayout.setConstraints(divButton,gbConst);	
		this.add(divButton);
		title = new JLabel("URO cv. 5");
		title.setHorizontalAlignment(JLabel.CENTER);
		title.setBorder(new EtchedBorder(EtchedBorder.LOWERED));
		gbConst.gridx = 0;
		gbConst.gridy = 6;
		gbConst.gridwidth = 3;
		gbLayout.setConstraints(title,gbConst);	
		this.add(title);	
		equalsButton = new JButton("=");
		equalsButton.addActionListener(new ClickEquals());
		gbConst.gridx = 3;
		gbConst.gridy = 6;
		gbConst.gridwidth = 1;
		gbLayout.setConstraints(equalsButton,gbConst);	
		this.add(equalsButton);	
	}
	
	//stisk cislice
	class ClickNumber implements ActionListener {
		public void actionPerformed(ActionEvent e) {
			String prevText=valueText.getText();
			JButton but = (JButton)e.getSource();
			if (prevText.equals("0")==false) valueText.setText(prevText.concat(but.getText()));
			else valueText.setText(but.getText());
		}
	}

	//vymazani
	class ClickClear implements ActionListener {
		public void actionPerformed(ActionEvent e) {
			valueText.setText("0");
		}
	}

	//desetinna carka
	class ClickDec implements ActionListener {
		public void actionPerformed(ActionEvent e) {
			if (valueText.getText().indexOf('.')==-1) valueText.setText(valueText.getText().concat("."));
		}
	}

	//operator
	class ClickOper implements ActionListener {
		public void actionPerformed(ActionEvent e) {
			num1 = new Double(valueText.getText());
			JButton but = (JButton)e.getSource();
			operator = but.getText();
			valueText.setText("0");
		}
	}

	//rovna se
	class ClickEquals implements ActionListener {
		public void actionPerformed(ActionEvent e) {
			double n1,n2,eq=0;
			num2 = new Double(valueText.getText());
			n1 = num1.doubleValue();
			n2 = num2.doubleValue();
			if (operator.equals("+")==true) eq=n1+n2;
			else if (operator.equals("-")==true) eq=n1-n2;
			else if (operator.equals("*")==true) eq=n1*n2;
			else if (operator.equals("/")==true) eq=n1/n2;
			
			valueText.setText(new String().valueOf(eq));
		}
	}
	
	//zmena fontu
	class ChangeFont implements ActionListener {	
		public void actionPerformed(ActionEvent e) {
			JRadioButton rdBut = (JRadioButton)e.getSource();
			if (rdBut.getText().equals("Big")==true) {
				Button0.setFont(new Font(null,Font.BOLD,15));
				Button1.setFont(new Font(null,Font.BOLD,15));
				Button2.setFont(new Font(null,Font.BOLD,15));
				Button3.setFont(new Font(null,Font.BOLD,15));
				Button4.setFont(new Font(null,Font.BOLD,15));
				Button5.setFont(new Font(null,Font.BOLD,15));
				Button6.setFont(new Font(null,Font.BOLD,15));
				Button7.setFont(new Font(null,Font.BOLD,15));
				Button8.setFont(new Font(null,Font.BOLD,15));
				Button9.setFont(new Font(null,Font.BOLD,15));
				clearButton.setFont(new Font(null,Font.BOLD,15));
				plusButton.setFont(new Font(null,Font.BOLD,15));
				minusButton.setFont(new Font(null,Font.BOLD,15));
				divButton.setFont(new Font(null,Font.BOLD,15));
				multiButton.setFont(new Font(null,Font.BOLD,15));
				equalsButton.setFont(new Font(null,Font.BOLD,15));
				normalButton.setFont(new Font(null,Font.BOLD,15));
				bigButton.setFont(new Font(null,Font.BOLD,15));
				title.setFont(new Font(null,Font.BOLD,15));
				valueText.setFont(new Font(null,Font.BOLD,15));
			}
			else {
				Button0.setFont(new Font(null,Font.BOLD,12));
				Button1.setFont(new Font(null,Font.BOLD,12));
				Button2.setFont(new Font(null,Font.BOLD,12));
				Button3.setFont(new Font(null,Font.BOLD,12));
				Button4.setFont(new Font(null,Font.BOLD,12));
				Button5.setFont(new Font(null,Font.BOLD,12));
				Button6.setFont(new Font(null,Font.BOLD,12));
				Button7.setFont(new Font(null,Font.BOLD,12));
				Button8.setFont(new Font(null,Font.BOLD,12));
				Button9.setFont(new Font(null,Font.BOLD,12));
				clearButton.setFont(new Font(null,Font.BOLD,12));
				plusButton.setFont(new Font(null,Font.BOLD,12));
				minusButton.setFont(new Font(null,Font.BOLD,12));
				divButton.setFont(new Font(null,Font.BOLD,12));
				multiButton.setFont(new Font(null,Font.BOLD,12));
				equalsButton.setFont(new Font(null,Font.BOLD,12));
				normalButton.setFont(new Font(null,Font.BOLD,12));
				bigButton.setFont(new Font(null,Font.BOLD,12));
				title.setFont(new Font(null,Font.BOLD,12));
				valueText.setFont(new Font(null,Font.BOLD,12));
			}
		}
	}
}