/*
  Jmeno a prijmeni: Marek Bober
  Datum vytvoreni:  24.12.2001
*/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

char id1[]="jmeno.ind";
char id2[]="dat_nar.ind";
char id3[]="pohl.ind";
char id4[]="vek.ind";
char id5[]="plat.ind";

/*Deklarace funkci*/
void help(void);          		/*Napoveda*/
void chyba(int cislo);    		/*Chyby                    */
void vypis(char *radek);  		/*vypis 1 polozky          */
void insertx1(char *soub);		/*vytvoreni indexu jmena   */
void insertx2(char *soub);		/*vytvoreni indexu dat_nar */
void insertx3(char *soub);		/*vytvoreni indexu pohlavi */
void insertx4(char *soub);		/*vytvoreni indexu veku    */
void insertx5(char *soub);		/*vytvoreni indexu platu   */
void CharQuickSort(char **A,int const AHigh,int iLo,int iHi);
					/*setrideni pole indexu    */
void list(char *soubor);
void listx(char *soubor,char *polozka);
void insert(char *soubor,char *polozka);
void search(char *soubor,char *polozka,char *co);
void modify(char *soubor,char *polozka,char *stara,char *nova);
void delete_p(char *soubor,char *polozka,char *co);

/*Definice funkci*/
void delete_p(char *soubor,char *polozka,char *co)
{
 FILE *sdat,*index;
 char (*pole)[40];
 char radek[80];
 char hodnota[80];
 int kolik=0;
 int j=0;
 int i,p,cislo;
 int stredniky[4];

 if ((pole=(char (*)[40])malloc(2000*40*sizeof(char *)))==NULL)
  {
   printf("Nedostatek pameti k alokaci pole.\n");
   exit(1);
  }
 if ((sdat=fopen(soubor,"r"))==NULL) chyba(1);
 while(fgets(radek,80,sdat)!=NULL) if (radek[0]!='\n') kolik++;
 fseek(sdat,0,SEEK_SET);
 if (kolik>0)
  {
   j=0;
   while(fgets(radek,80,sdat)!=NULL)
    {
     j++;
     strcpy(pole[j-1]," ");
     strcat(pole[j-1],radek);
    }
  }
 fclose(sdat);
 if (kolik>0)
  {
   if ((sdat=fopen(soubor,"w"))==NULL) chyba(1);
   if (strcmp(polozka,"jmeno")==0)
    if ((index=fopen(id1,"r"))==NULL) chyba(2);
   if (strcmp(polozka,"dat_nar")==0)
    if ((index=fopen(id2,"r"))==NULL) chyba(2);
   if (strcmp(polozka,"pohlavi")==0)
    if ((index=fopen(id3,"r"))==NULL) chyba(2);
   if (strcmp(polozka,"vek")==0)
    if ((index=fopen(id4,"r"))==NULL) chyba(2);
   if (strcmp(polozka,"plat")==0)
    if ((index=fopen(id5,"r"))==NULL) chyba(2);
   while(fgets(radek,80,index)!=NULL)
    {
     if (radek[0]!='\n')
      {
       if (strstr(radek,co)!=NULL)
	{
	 for(i=0;i<strlen(radek);i++) if (radek[i]==';') break;
	 radek[strlen(radek)-1]='\0';
	 cislo=atoi(radek+i+1);
	}
      }
    }
   fclose(index);
   for(i=0;i<kolik;i++)
    if (i!=(cislo-1)) fprintf(sdat,"%s",pole[i]+1);
   fclose(sdat);
  }
 free(pole);
 insertx1(soubor);
 insertx2(soubor);
 insertx3(soubor);
 insertx4(soubor);
 insertx5(soubor);
 printf("Polozka byla vymazana.\n");
}

void modify(char *soubor,char *polozka,char *stara,char *nova)
{
 FILE *sdat,*index;
 char (*pole)[40];
 char radek[80];
 char hodnota[80];
 char jmeno[21],dat_nar[11],pohlavi[2],vek[3],plat[12];
 int kolik=0;
 int j=0;
 int i,p,cislo;
 int stredniky[4];

 if ((pole=(char (*)[40])malloc(2000*40*sizeof(char *)))==NULL)
  {
   printf("Nedostatek pameti k alokaci pole.\n");
   exit(1);
  }
 if ((sdat=fopen(soubor,"r"))==NULL) chyba(1);
 while(fgets(radek,80,sdat)!=NULL) if (radek[0]!='\n') kolik++;
 fseek(sdat,0,SEEK_SET);
 if (kolik>0)
  {
   j=0;
   while(fgets(radek,80,sdat)!=NULL)
    {
     j++;
     strcpy(pole[j-1]," ");
     strcat(pole[j-1],radek);
    }
  }
 fclose(sdat);
 if (kolik>0)
  {
   if ((sdat=fopen(soubor,"w"))==NULL) chyba(1);
   if (strcmp(polozka,"jmeno")==0)
    if ((index=fopen(id1,"r"))==NULL) chyba(2);
   if (strcmp(polozka,"dat_nar")==0)
    if ((index=fopen(id2,"r"))==NULL) chyba(2);
   if (strcmp(polozka,"pohlavi")==0)
    if ((index=fopen(id3,"r"))==NULL) chyba(2);
   if (strcmp(polozka,"vek")==0)
    if ((index=fopen(id4,"r"))==NULL) chyba(2);
   if (strcmp(polozka,"plat")==0)
    if ((index=fopen(id5,"r"))==NULL) chyba(2);
   while(fgets(radek,80,index)!=NULL)
    {
     if (radek[0]!='\n')
      {
       for(i=0;i<strlen(radek);i++) if (radek[i]==';') break;
       radek[strlen(radek)-1]='\0';
       cislo=atoi(radek+i+1);
       strncpy(hodnota,radek,i);
       hodnota[i]='\0';
       if (strcmp(hodnota,stara)==0) pole[cislo-1][0]='*';
      }
    }
   fclose(index);
  }
 for(i=0;i<kolik;i++)
  {
   if (pole[i][0]=='*')
    {
     p=0;
     for(j=0;j<strlen(pole[i]);j++)
      {
       if (pole[i][j]==';')
	{
	 p++;
	 stredniky[p-1]=j-1;
	}
      }
     strncpy(jmeno,pole[i]+1,stredniky[0]+1);
     jmeno[stredniky[0]]='\0';
     strncpy(dat_nar,pole[i]+1+stredniky[0]+1,stredniky[1]-stredniky[0]);
     dat_nar[stredniky[1]-stredniky[0]-1]='\0';
     strncpy(pohlavi,pole[i]+1+stredniky[1]+1,stredniky[2]-stredniky[1]);
     pohlavi[stredniky[2]-stredniky[1]-1]='\0';
     strncpy(vek,pole[i]+1+stredniky[2]+1,stredniky[3]-stredniky[2]);
     vek[stredniky[3]-stredniky[2]-1]='\0';
     strcpy(plat,pole[i]+1+stredniky[3]+1);
     if (strcmp(polozka,"jmeno")==0) strcpy(jmeno,nova);
     if (strcmp(polozka,"dat_nar")==0) strcpy(dat_nar,nova);
     if (strcmp(polozka,"pohlavi")==0) strcpy(pohlavi,nova);
     if (strcmp(polozka,"vek")==0) strcpy(vek,nova);
     if (strcmp(polozka,"plat")==0)
      {
       strcpy(plat,nova);
       strcat(plat,"\n");
      }
     fprintf(sdat,"%s;%s;%s;%s;%s",jmeno,dat_nar,pohlavi,vek,plat);
    }
   else fprintf(sdat,"%s",pole[i]+1);
  }
 fclose(sdat);
 free(pole);
 if (strcmp(polozka,"jmeno")==0) insertx1(soubor);
 if (strcmp(polozka,"dat_nar")==0) insertx2(soubor);
 if (strcmp(polozka,"pohlavi")==0) insertx3(soubor);
 if (strcmp(polozka,"vek")==0) insertx4(soubor);
 if (strcmp(polozka,"plat")==0) insertx5(soubor);
 printf("Polozka byla modifikovana.\n");
}

void search(char *soubor,char *polozka,char *co)
{
 FILE *sdat,*index;
 char radek[80];
 char hodnota[80];
 int i,j,p;
 int cislo=0;

 if ((sdat=fopen(soubor,"r"))==NULL) chyba(1);

 if (strcmp(polozka,"jmeno")==0)
  if ((index=fopen(id1,"r"))==NULL) chyba(2);
 if (strcmp(polozka,"dat_nar")==0)
  if ((index=fopen(id2,"r"))==NULL) chyba(2);
 if (strcmp(polozka,"pohlavi")==0)
  if ((index=fopen(id3,"r"))==NULL) chyba(2);
 if (strcmp(polozka,"vek")==0)
  if ((index=fopen(id4,"r"))==NULL) chyba(2);
 if (strcmp(polozka,"plat")==0)
  if ((index=fopen(id5,"r"))==NULL) chyba(2);
 printf("\nJMENO\t\tDATUM NAROZENI\tPOHLAVI\tVEK\tPLAT\n\n");
 while(fgets(radek,80,index)!=NULL)
  {
   if (radek[0]!='\n')
    {
     for(i=0;i<strlen(radek);i++) if (radek[i]==';') break;
     radek[strlen(radek)-1]='\0';
     cislo=atoi(radek+i+1);
     strncpy(hodnota,radek,i);
     hodnota[i]='\0';
     if(strcmp(hodnota,co)==0)
      {
       p=0;
       fseek(sdat,0,SEEK_SET);
       while(fgets(radek,80,sdat)!=NULL)
	{
	 p++;
	 if (p==cislo) vypis(radek);
	}
      }
    }
  }
 fclose(index);
 fclose(sdat);
}

void myqsort(char **soub,int pocet)
{
 char pom[80]={0,};
 int i,j;
 for(i=0;i<pocet-1;i++)
 for(j=0;j<pocet-1;j++)
 if(strcmp(soub[j],soub[j+1])>0)
  {
   strcpy(pom,soub[j]);
   strcpy(soub[j],soub[j+1]);
   strcpy(soub[j+1],pom);
  }
}

void CharQuickSort(char **A,int const AHigh,int iLo,int iHi)
{
 int Lo, Hi;
 char Mid[80],T[80];
 Lo = iLo;
 Hi = iHi;
 strcpy(Mid,A[(Lo+Hi)/2]);
 do
  {
   while ((strcmp(A[Lo],Mid))<0) Lo++;
   while ((strcmp(A[Hi],Mid))>0) Hi--;
   if (Lo <= Hi)
    {
     strcpy(T,A[Lo]);
     strcpy(A[Lo],A[Hi]);
     strcpy(A[Hi],T);
     Lo++;
     Hi--;
    }
  }
 while (Lo <= Hi);
 if (Hi > iLo) CharQuickSort(A, AHigh, iLo, Hi);
 if (Lo < iHi) CharQuickSort(A, AHigh, Lo, iHi);
}


void insertx1(char *soub)
{
 FILE *sdat,*fx;

 char **pole;
 char radek[80],cislo[40];
 int kolik=0;
 int i,j;

 if ((sdat=fopen(soub,"r"))==NULL) chyba(1);
 while(fgets(radek,80,sdat)!=NULL) if (radek[0]!='\n') kolik++;
 if ((pole=(char **)malloc(kolik*sizeof(char*)))==NULL)
  {
   printf("Nedostatek pameti k alokaci pole.\n");
   exit(1);
  }
 fseek(sdat,0,SEEK_SET);
 if (kolik>0)
  {
   j=0;
   while(fgets(radek,80,sdat)!=NULL)
    {
     if (radek[0]!='\n')
      {
       for(i=0;i<strlen(radek);i++) if (radek[i]==';') break;
       j++;
       if ((pole[j-1]=(char*)malloc((strlen(radek)+3)*sizeof(char)))==NULL)
	{
	 printf("Nedostatek pameti k alokaci pole %d.\n",j-1);
	 exit(1);
	}
       strncpy(pole[j-1],radek,i+1);
       pole[j-1][i+1]='\0';
       sprintf(cislo,"%d",j);
       strcat(pole[j-1],cislo);
      }
    }
   CharQuickSort(pole,1,0,kolik);
  }
 fclose(sdat);
 if (kolik>0)
  {
   if ((fx=fopen(id1,"w"))==NULL) chyba(2);
   for(i=1;i<=kolik;i++) fprintf(fx,"%s\n",pole[i-1]);
   fclose(fx);
  }
 free(pole);
}

void insertx2(char *soub)
{
 FILE *sdat,*fx;

 char **pole;
 char radek[80],cislo[40];
 int kolik=0;
 int i,j,p;
 int stredniky[4];

 if ((sdat=fopen(soub,"r"))==NULL) chyba(1);
 while(fgets(radek,80,sdat)!=NULL) if (radek[0]!='\n') kolik++;
 if ((pole=(char **)malloc(kolik*sizeof(char*)))==NULL)
  {
   printf("Nedostatek pameti k alokaci pole.\n");
   exit(1);
  }
 fseek(sdat,0,SEEK_SET);
 if (kolik>0)
  {
   j=0;
   while(fgets(radek,80,sdat)!=NULL)
    {
     if (radek[0]!='\n')
      {
       p=0;
       for(i=0;i<strlen(radek);i++)
	if (radek[i]==';')
	 {
	  p++;
	  stredniky[p-1]=i;
	 }
       j++;
       if ((pole[j-1]=(char*)malloc((strlen(radek)+3)*sizeof(char)))==NULL)
	{
	 printf("Nedostatek pameti k alokaci pole %d.\n",j-1);
	 exit(1);
	}
       strncpy(pole[j-1],radek+stredniky[0]+1,stredniky[1]-stredniky[0]);
       pole[j-1][stredniky[1]-stredniky[0]-1]='\0';
       sprintf(cislo,"%d",j);
       strcat(pole[j-1],";");
       strcat(pole[j-1],cislo);
      }
    }
   CharQuickSort(pole,1,0,kolik);
  }
 fclose(sdat);
 if (kolik>0)
  {
   if ((fx=fopen(id2,"w"))==NULL) chyba(2);
   for(i=1;i<=kolik;i++) fprintf(fx,"%s\n",pole[i-1]);
   fclose(fx);
  }
 free(pole);
}

void insertx3(char *soub)
{
 FILE *sdat,*fx;

 char **pole;
 char radek[80],cislo[40];
 int kolik=0;
 int i,j,p;
 int stredniky[4];

 if ((sdat=fopen(soub,"r"))==NULL) chyba(1);
 while(fgets(radek,80,sdat)!=NULL) if (radek[0]!='\n') kolik++;
 if ((pole=(char **)malloc(kolik*sizeof(char*)))==NULL)
  {
   printf("Nedostatek pameti k alokaci pole.\n");
   exit(1);
  }
 fseek(sdat,0,SEEK_SET);
 if (kolik>0)
  {
   j=0;
   while(fgets(radek,80,sdat)!=NULL)
    {
     if (radek[0]!='\n')
      {
       p=0;
       for(i=0;i<strlen(radek);i++)
	if (radek[i]==';')
	 {
	  p++;
	  stredniky[p-1]=i;
	 }
       j++;
       if ((pole[j-1]=(char*)malloc((strlen(radek)+3)*sizeof(char)))==NULL)
	{
	 printf("Nedostatek pameti k alokaci pole %d.\n",j-1);
	 exit(1);
	}
       strncpy(pole[j-1],radek+stredniky[1]+1,stredniky[2]-stredniky[1]);
       pole[j-1][stredniky[2]-stredniky[1]-1]='\0';
       sprintf(cislo,"%d",j);
       strcat(pole[j-1],";");
       strcat(pole[j-1],cislo);
      }
    }
   CharQuickSort(pole,1,0,kolik);
  }
 fclose(sdat);
 if (kolik>0)
  {
   if ((fx=fopen(id3,"w"))==NULL) chyba(2);
   for(i=1;i<=kolik;i++) fprintf(fx,"%s\n",pole[i-1]);
   fclose(fx);
  }
 free(pole);
}

void insertx4(char *soub)
{
 FILE *sdat,*fx;

 char **pole;
 char radek[80],cislo[40];
 int kolik=0;
 int i,j,p;
 int stredniky[4];

 if ((sdat=fopen(soub,"r"))==NULL) chyba(1);
 while(fgets(radek,80,sdat)!=NULL) if (radek[0]!='\n') kolik++;
 if ((pole=(char **)malloc(kolik*sizeof(char*)))==NULL)
  {
   printf("Nedostatek pameti k alokaci pole.\n");
   exit(1);
  }
 fseek(sdat,0,SEEK_SET);
 if (kolik>0)
  {
   j=0;
   while(fgets(radek,80,sdat)!=NULL)
    {
     if (radek[0]!='\n')
      {
       p=0;
       for(i=0;i<strlen(radek);i++)
	if (radek[i]==';')
	 {
	  p++;
	  stredniky[p-1]=i;
	 }
       j++;
       if ((pole[j-1]=(char*)malloc((strlen(radek)+3)*sizeof(char)))==NULL)
	{
	 printf("Nedostatek pameti k alokaci pole %d.\n",j-1);
	 exit(1);
	}
       strncpy(pole[j-1],radek+stredniky[2]+1,stredniky[3]-stredniky[2]);
       pole[j-1][stredniky[3]-stredniky[2]-1]='\0';
       sprintf(cislo,"%d",j);
       strcat(pole[j-1],";");
       strcat(pole[j-1],cislo);
      }
    }
   CharQuickSort(pole,1,0,kolik);
  }
 fclose(sdat);
 if (kolik>0)
  {
   if ((fx=fopen(id4,"w"))==NULL) chyba(2);
   for(i=1;i<=kolik;i++) fprintf(fx,"%s\n",pole[i-1]);
   fclose(fx);
  }
 free(pole);
}

void insertx5(char *soub)
{
 FILE *sdat,*fx;

 char **pole;
 char radek[80],cislo[40];
 int kolik=0;
 int i,j,p;
 int stredniky[4];

 if ((sdat=fopen(soub,"r"))==NULL) chyba(1);
 while(fgets(radek,80,sdat)!=NULL) if (radek[0]!='\n') kolik++;
 if ((pole=(char **)malloc(kolik*sizeof(char*)))==NULL)
  {
   printf("Nedostatek pameti k alokaci pole.\n");
   exit(1);
  }
 fseek(sdat,0,SEEK_SET);
 if (kolik>0)
  {
   j=0;
   while(fgets(radek,80,sdat)!=NULL)
    {
     if (radek[0]!='\n')
      {
       p=0;
       for(i=0;i<strlen(radek);i++)
	if (radek[i]==';')
	 {
	  p++;
	  stredniky[p-1]=i;
	 }
       j++;
       if ((pole[j-1]=(char*)malloc((strlen(radek)+3)*sizeof(char)))==NULL)
	{
	 printf("Nedostatek pameti k alokaci pole %d.\n",j-1);
	 exit(1);
	}
       strcpy(pole[j-1],radek+stredniky[3]+1);
       pole[j-1][strlen(pole[j-1])-1]='\0';
       sprintf(cislo,"%d",j);
       strcat(pole[j-1],";");
       strcat(pole[j-1],cislo);
      }
    }
   CharQuickSort(pole,1,0,kolik);
  }
 fclose(sdat);
 if (kolik>0)
  {
   if ((fx=fopen(id5,"w"))==NULL) chyba(2);
   for(i=1;i<=kolik;i++) fprintf(fx,"%s\n",pole[i-1]);
   fclose(fx);
  }
 free(pole);
}

void insert(char *soubor,char *polozka)
{
 FILE *sdat;
 int i,p;
 char pom[80]={0,},pom1[80]={0,},pohl[5]={0,};
 char *ptr;
 int stredniky[4];

 if ((sdat=fopen(soubor,"a"))==NULL) chyba(1);
 p=0;
 for(i=0;i<strlen(polozka);i++)
 if (polozka[i]==';')
  {
   p++;
   stredniky[p-1]=i;
  }
 strncpy(pom,polozka+stredniky[1]+1,stredniky[2]-stredniky[1]);
 pom[stredniky[2]-stredniky[1]-1]='\0';
 if (strcmp(pom,"muz")==0) pohl[0]='0';
 if (strcmp(pom,"zena")==0) pohl[0]='1';
 strncpy(pom1,polozka,stredniky[1]+1);
 strcat(pom1,pohl);
 strncpy(pom,polozka+stredniky[2],stredniky[4]-stredniky[3]);
 pom[stredniky[4]-stredniky[3]-1]='\0';
 strcat(pom1,pom);
 strcpy(polozka,pom1);
 fprintf(sdat,"%s\n",polozka);
 fclose(sdat);
 printf("Setriduji indexy...\n");
 insertx1(soubor);
 insertx2(soubor);
 insertx3(soubor);
 insertx4(soubor);
 insertx5(soubor);
 printf("Polozka byla ulozena.\n");
}

void listx(char *soubor,char *polozka)
{
 FILE *sdat,*index;
 char radek[80];
 int i,j,p,cislo;

 if ((strcmp(polozka,"jmeno"))==0)
  if ((index=fopen(id1,"r")) == NULL) chyba(2);
 if ((strcmp(polozka,"dat_nar"))==0)
  if ((index=fopen(id2,"r")) == NULL) chyba(2);
 if ((strcmp(polozka,"pohlavi"))==0)
  if ((index=fopen(id3,"r")) == NULL) chyba(2);
 if ((strcmp(polozka,"vek"))==0)
  if ((index=fopen(id4,"r")) == NULL) chyba(2);
 if ((strcmp(polozka,"plat"))==0)
  if ((index=fopen(id5,"r")) == NULL) chyba(2);

 printf("\nJMENO\t\tDATUM NAROZENI\tPOHLAVI\tVEK\tPLAT\n\n");
 while(fgets(radek,80,index)!=NULL)
  {
   if (radek[0]!='\n')
    {
     for(i=0;i<strlen(radek);i++)
      {
       if (radek[i]==';')
	break;
      }
     radek[strlen(radek)-1]='\0';
     cislo=atoi(radek+i+1);
     p=0;
     if ((sdat=fopen(soubor,"r")) == NULL) chyba(1);
     fseek(sdat,0,SEEK_SET);
     while(fgets(radek,80,sdat)!=NULL)
      {
       p++;
       if (p==cislo) vypis(radek);
      }
     fclose(sdat);
    }
  }
 fclose(index);
}

void vypis(char *radek)
{
 int strednik[4],i;
 int p=0;
 char jmeno[21],narozeni[11],pohlavi[5],vek[3],plat[12];
 double dplat;

 for(i=0;i<strlen(radek);i++)
  {
   if (radek[i]==';')
    {
     p++;
     strednik[p-1]=i;
    }
  }
 strncpy(jmeno,radek,strednik[0]+1);
 jmeno[strednik[0]]='\0';
 strncpy(narozeni,radek+strednik[0]+1,strednik[1]-strednik[0]);
 narozeni[strednik[1]-strednik[0]-1]='\0';
 strncpy(pohlavi,radek+strednik[1]+1,strednik[2]-strednik[1]);
 pohlavi[strednik[2]-strednik[1]-1]='\0';
 strncpy(vek,radek+strednik[2]+1,strednik[3]-strednik[2]);
 vek[strednik[3]-strednik[2]-1]='\0';
 strcpy(plat,radek+strednik[3]+1);
 dplat=atof(plat);
 if (strcmp(pohlavi,"0")==0) strcpy(pohlavi,"Muz");
 if (strcmp(pohlavi,"1")==0) strcpy(pohlavi,"Zena");
 printf("%s\t\t%s\t%s\t%s\t%8.2f\n",jmeno,narozeni,pohlavi,vek,dplat);
}

void list(char *soubor)
{
 FILE *sdat;
 char radek[80];

 if ((sdat=fopen(soubor,"r")) == NULL) chyba(1);
 printf("\nJMENO\t\tDATUM NAROZENI\tPOHLAVI\tVEK\tPLAT\n\n");
 while(fgets(radek,80,sdat)!=NULL) if (radek[0]!='\n') vypis(radek);
 fclose(sdat);
}

void help(void)
{
 printf("\nTZD -f dbfile parametry\n\n");
 printf("dbfile - nazev souboru databaze\n\n");
 printf("Parametr                       Vyznam    Popis\n\n");
 printf("-l                             listing   sekvencni vypis\n");
 printf("-x nazev_polozky               index     vypis dle hodnoty ");
 printf("nazev_polozky\n");
 printf("                                         uvedene za parametrem\n");
 printf("-i \"jmeno;dat_nar;pohl;vek;plat\" insert    vlozeni zaznamu s ");
 printf("polozek v uvedenem\n");
 printf("                                         poradi\n");
 printf("-s nazev_polozky hodnota       search    vyhledani a vypis vsech ");
 printf("zaznamu\n");
 printf("                                         splnujici podminku\n");
 printf("-e nazev_polozky hodnota_stara edit      modifikace vsech");
 printf(" polozek s hodnotou\n   hodnota_nova");
 printf("                          stara na hodnotu nova\n");
 printf("-d nazev_polozky hodnota       delete    zruseni vsech zaznamu");
 printf(" obsahujici\n");
 printf("                                         polozku s uvedenou");
 printf(" hodnotou\n\n");
 printf("\n\nPr.1 pro listing:\n     tzd -f data.dat -l\n");
 printf("Pr.2 pro index:  \n     tzd -f data.dat -x jmeno\n");
 printf("Pr.3 pro insert: \n");
 printf("     tzd -f data.dat -i \"Marek;1969-10-15;muz;21;4500.20\"\n");
 printf("Pr.4 pro search: \n     tzd -f data.dat -s jmeno Marek\n");
 printf("Pr.5 pro edit:   \n     tzd -f data.dat -e jmeno Marek Milan\n");
 printf("Pr.6 pro delete: \n     tzd -f data.dat -d jmeno Milan\n\n");
}

void chyba(int cislo)
{
 if (cislo==1) printf("Nemohu otevrit datovy soubor.\n");
 if (cislo==2) printf("Nemohu otevrit indexovy soubor.\n");
 if (cislo==3) printf("Nemohu vytvorit konfiguracni soubor.\n");
 if (cislo==3) printf("Nemohu otevrit konfiguracni soubor.\n");
 exit(1);
}

void uloz_soubor(char *soubor)
{
 FILE *sdat;

 if ((sdat=fopen("dbfile.cfg","wt")) == NULL) chyba(3);
 fprintf(sdat,"%s",soubor);
 fclose(sdat);
}

char *nacti_soubor(void)
{
 FILE *sdat;
 char *soubor;
 
 soubor=(char *)malloc(50);
 if ((sdat=fopen("dbfile.cfg","rt")) == NULL) chyba(4);
 fscanf(sdat,"%s",soubor);
 fclose(sdat);
 return soubor;
}

/*Hlavni program*/
int main(int argc, char **argv)
{
 if (argc==1)
  {
   help();
   return 0;
  }
 if (argc!=1)
  {
   if (strcmp(argv[1],"-f")==0)
    {
     uloz_soubor(argv[2]);
     if (strcmp(argv[3],"-l")==0)
      {
       list(argv[2]);
       return 0;
      }
     if (strcmp(argv[3],"-x")==0)
      {
       listx(argv[2],argv[4]);
       return 0;
      }
     if (strcmp(argv[3],"-i")==0)
      {
       insert(argv[2],argv[4]);
       return 0;
      }
     if (strcmp(argv[3],"-s")==0)
      {
       search(argv[2],argv[4],argv[5]);
       return 0;
      }
     if (strcmp(argv[3],"-e")==0)
      {
       modify(argv[2],argv[4],argv[5],argv[6]);
       return 0;
      }
     if (strcmp(argv[3],"-d")==0)
      {
       delete_p(argv[2],argv[4],argv[5]);
       return 0;
      }
    }

    if (strcmp(argv[1],"-f")!=0)
    {
       argv[0]=nacti_soubor();
     }
    {
     if (strcmp(argv[1],"-l")==0)
      {
       list(argv[0]);
       return 0;
      }
     if (strcmp(argv[1],"-x")==0)
      {
       listx(argv[0],argv[2]);
       return 0;
      }
     if (strcmp(argv[1],"-i")==0)
      {
       insert(argv[0],argv[2]);
       return 0;
      }
     if (strcmp(argv[1],"-s")==0)
      {
       search(argv[0],argv[2],argv[3]);
       return 0;
      }
     if (strcmp(argv[1],"-e")==0)
      {
       modify(argv[0],argv[2],argv[3],argv[4]);
       return 0;
      }
     if (strcmp(argv[1],"-d")==0)
      {
       delete_p(argv[0],argv[2],argv[3]);
       return 0;
      }
    }
  }
 return 0;
}
